/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.tasklet.TaskletConnection;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletTerminatingException;
import com.ibm.hwmca.fw.tasklet.impl.Queue;
import com.ibm.hwmca.fw.tasklet.impl.TaskletData;
import com.ibm.hwmca.fw.tasklet.impl.TaskletInitialRequest;
import com.ibm.hwmca.fw.tasklet.impl.TaskletRegistry;
import com.ibm.hwmca.fw.tasklet.impl.TaskletRegistryEntry;
import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ExitControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ExitControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.TerminateControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.response.RedirectResponseData;
import com.ibm.hwmca.fw.tasklet.xport.NewConnectionSource;
import com.ibm.hwmca.fw.tasklet.xport.TaskletControlException;
import com.ibm.hwmca.fw.tasklet.xport.TaskletController;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;

public class TaskletManager {
    private static final String TRACE_MASKT = "XTSKSTMT";
    private static final String TRACE_MASKF = "XTSKSTMF";
    private static final String TRACE_MASKD = "XTSKSTMD";
    protected Tasklet tasklet = null;
    protected boolean exemptFromTaskletAuthorizationChecking = false;
    protected int traceId = -1;
    protected NewConnectionSource newConnectionSource = null;
    protected static final TaskletRegistry registry = TaskletRegistry.getRegistry();
    protected RedirectResponseData redirectData = null;
    protected boolean terminateUnderWay = false;
    protected boolean terminateRequested = false;
    protected int tooBusyToTerminateCount = 0;
    protected Object terminateLock = new Object();
    protected Object controlRequestsLock = new Object();
    protected Queue controlRequests = new Queue();
    protected ControlRequest outstandingRequest = null;
    public static final short TASKLET_TERMINATION_ERROR_ID = 2481;

    public TaskletManager() {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <init>");
    }

    public Tasklet getTasklet() {
        return this.tasklet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tooBusyToTerminate(boolean tooBusyToTerminate) throws TaskletTerminatingException {
        Object object = this.terminateLock;
        synchronized (object) {
            this.tooBusyToTerminateCount = tooBusyToTerminate ? ++this.tooBusyToTerminateCount : --this.tooBusyToTerminateCount;
            if (this.terminateRequested && this.tooBusyToTerminateCount <= 0) {
                this.terminate();
                throw new TaskletTerminatingException("Terminate requested during 'busy' period, honoring request now.");
            }
        }
    }

    public TaskletConnection accept(String name) {
        if (this.newConnectionSource != null) {
            return this.newConnectionSource.accept(name);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isTerminateUnderWay() {
        return this.terminateUnderWay;
    }

    public boolean isTerminateRequested() {
        return this.terminateRequested;
    }

    public void setNewConnectionSource(NewConnectionSource newConnectionSource) {
        this.newConnectionSource = newConnectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TaskletRequest newSession(TaskletRequest request) throws ClassNotFoundException, InstantiationException, IllegalAccessException, TaskletException {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:newSession> newSession(" + request + ")");
        if (!(request instanceof TaskletInitialRequest)) {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Protocol: no initial request prior to established tasklet session.");
            throw new IllegalStateException("Protocol: no initial request prior to established tasklet session.");
        }
        TaskletInitialRequest initialRequest = (TaskletInitialRequest)request;
        TaskletData taskletData = initialRequest.getTaskletData();
        TaskletRegistryEntry taskletRegistryEntry = registry.get(taskletData.getTaskletId());
        if (taskletData.getTaskletId() != -1) {
            if (taskletRegistryEntry == null) {
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Error: Apparent redirecting tasklet " + "but no redirect data found.");
                throw new TaskletException("Redirect detected but no registry entry was setup to handle inbound request!");
            }
            taskletData.setInitializationData(taskletRegistryEntry.redirectResponseData.getRedirectInitData());
            this.redirectData = taskletRegistryEntry.redirectResponseData;
        } else {
            taskletData.setTaskletId(TaskletRegistry.getNextTaskletId());
            this.redirectData = null;
            taskletRegistryEntry = new TaskletRegistryEntry();
            registry.put(taskletData.getTaskletId(), taskletRegistryEntry);
        }
        this.traceId = taskletData.getTaskletId();
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] trace id bound from initial request.");
        Object object = this.controlRequestsLock;
        synchronized (object) {
            this.controlRequestsLock.notifyAll();
        }
        String newTaskletClassName = taskletData.getServerTaskletClass();
        if (this.redirectData == null) {
            if (!this.exemptFromTaskletAuthorizationChecking) {
                TaskletController.checkPermission(newTaskletClassName);
            }
        } else if (!newTaskletClassName.equals(this.redirectData.getRedirectTarget())) {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Warning: Redirect Spoof.  '" + newTaskletClassName + "' does not match expected '" + this.redirectData.getRedirectTarget() + "'");
            throw new TaskletControlException("Redirect Spoof, '" + newTaskletClassName + "' does not match expected '" + this.redirectData.getRedirectTarget() + "'");
        }
        this.tasklet = (Tasklet)Class.forName(newTaskletClassName).newInstance();
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:birth> " + this.tasklet);
        this.tasklet.getClientInformation().setLocale(taskletData.getLocale());
        this.tasklet.setTraceId(this.traceId);
        this.tasklet.setTaskletManager(this);
        this.tasklet.setRedirectData(this.redirectData == null ? null : this.redirectData.getRedirectData());
        this.tasklet.setTaskletId(taskletData.getTaskletId());
        taskletRegistryEntry.tasklet = this.tasklet;
        registry.associate(this.tasklet.getTaskletId(), initialRequest.getTaskletData().getParentTaskletId());
        this.tasklet.init(taskletData.getInitializationData());
        TaskletRequest firstRequest = this.getFirstRequest(initialRequest);
        if (this.redirectData != null) {
            firstRequest.setDataMap(this.redirectData.getRedirectInitRequestData());
        }
        return firstRequest;
    }

    protected TaskletResponse getEmptyResponse() {
        return new TaskletResponse();
    }

    protected TaskletRequest getFirstRequest(TaskletRequest cause) {
        TaskletRequest request = new TaskletRequest();
        request.setInitialRequest(true);
        if (cause.doesDataExist()) {
            request.setDataMap(cause.getDataMap());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] terminate() entry.");
        try {
            Object object = this.terminateLock;
            synchronized (object) {
                this.terminateRequested = true;
                if (!this.terminateUnderWay && this.tooBusyToTerminateCount <= 0) {
                    this.terminateUnderWay = true;
                    try {
                        this.postControlRequest(new TerminateControlRequest());
                    }
                    catch (TaskletException e) {
                        // empty catch block
                    }
                    if (this.tasklet != null) {
                        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] !null tasklet");
                        TaskletRegistryEntry tre = registry.remove(this.tasklet.getTaskletId());
                        if (tre != null) {
                            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] calling destroy on TRE");
                            try {
                                tre.destroy();
                            }
                            catch (RuntimeException e) {
                                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] RuntimeException (" + e + ") caught and ignored when calling tasklet destroy()");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] WARNING: terminate() was unable to find the TRE for the tasklet.");
                        }
                        this.tasklet = null;
                    } else {
                        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] tasklet was null");
                    }
                }
            }
            object = this.controlRequestsLock;
            synchronized (object) {
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] notifies controlRequestLock waiters...");
                Iterator iterator = this.controlRequests.iterator();
                while (iterator.hasNext()) {
                    ((ControlRequest)iterator.next()).terminate();
                }
                if (this.outstandingRequest != null) {
                    this.outstandingRequest.terminate();
                }
                this.controlRequestsLock.notifyAll();
            }
        }
        finally {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] terminate() exits.");
        }
    }

    public void processResponse(ControlResponse response) {
        if (this.outstandingRequest != null) {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] posting outstanding request..");
            this.outstandingRequest.postResponse(response);
        }
        this.outstandingRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlRequest getControlRequest(ControlResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] getControlRequest(" + response + ") entry.");
        this.processResponse(response);
        Object object = this.controlRequestsLock;
        synchronized (object) {
            while (!this.terminateUnderWay && this.controlRequests.empty()) {
                try {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] getControlRequest() waits... (" + this.hashCode() + ")");
                    this.controlRequestsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.terminateUnderWay) {
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] getControlRequest() notes terminate is occuring, returning");
            }
            this.outstandingRequest = this.terminateUnderWay ? new TerminateControlRequest() : (ControlRequest)this.controlRequests.pull();
        }
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "]" + " getControlRequest() returns control request to caller.");
        return this.outstandingRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postControlRequest(ControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] postControlRequest(" + request + ")");
        boolean toReturn = true;
        if (request != null) {
            Object object = this.controlRequestsLock;
            synchronized (object) {
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] postControlRequest() posting...");
                if (this.terminateUnderWay) {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] terminate underway, calling terminate on request, ignoring post.");
                    request.terminate();
                    toReturn = false;
                } else {
                    this.controlRequests.push(request);
                }
                this.controlRequestsLock.notifyAll();
            }
        } else {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] postControlRequest() attempt to post null request ignored.");
            toReturn = false;
        }
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] postControlRequest(" + request + ") returns.");
        return toReturn;
    }

    protected TaskletResponse processThrowable(Throwable throwable) throws TaskletException {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof TaskletTerminatingException) {
            throw (TaskletTerminatingException)throwable;
        }
        String traceBack = XFrameUtils.getStackTrace(throwable);
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:processThrowable>\n" + traceBack);
        try {
            FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "Tasklet-S");
            FrameworkLog logEntry = new FrameworkLog(logInfo, 2481);
            StringBuffer sb = new StringBuffer(1024);
            sb.append("TaskletManager's processThrowable() invoked").append("\n");
            sb.append("Stack: (also look for other info logs in close proximity)\n").append(XFrameUtils.getStackTrace(throwable)).append("\n");
            logEntry.add(sb.toString());
            logEntry.log(FrameworkLogAttributes.INFO_LOG);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "An exception from the logger...");
            Trace.trace(TRACE_MASKF, e);
        }
        if (this.tasklet != null) {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "]" + " Throwable processing, calling tasklet logException() method.");
            try {
                this.tasklet.logException(throwable);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            TaskletRegistryEntry tre = registry.remove(this.tasklet.getTaskletId());
            if (tre != null) {
                try {
                    tre.destroy();
                }
                catch (RuntimeException e) {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] RuntimeException (" + e + ") caught and ignored when calling tasklet destroy()");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "]" + " 'early' dispose during throwable processing fails to find the TRE.");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "]" + " Throwable processing, unable to log as tasklet dosn't yet exist.");
        }
        TaskletResponse response = this.getEmptyResponse();
        response.setTaskletId(this.tasklet != null ? this.tasklet.getTaskletId() : -1);
        response.error(new LocalizableText("Task ends due to uncaught exception."), traceBack, throwable);
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Throwable processing, flowing error response to ");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized TaskletResponse init(TaskletInitialRequest initialRequest) throws TaskletException {
        void var2_2;
        TaskletResponse response;
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:init> init(" + initialRequest + ") entry");
        try {
            this.tooBusyToTerminate(true);
            response = this.request(this.newSession(initialRequest));
        }
        catch (Throwable throwable) {
            response = this.processThrowable(throwable);
        }
        finally {
            this.tooBusyToTerminate(false);
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskletResponse request(TaskletRequest passedRequest) throws TaskletException {
        TaskletResponse response;
        block11: {
            Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] request(" + passedRequest + ") entry");
            response = this.getEmptyResponse();
            TaskletRequest request = passedRequest;
            try {
                this.tooBusyToTerminate(true);
                if (this.tasklet == null) {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] New session, before service.");
                    request = this.newSession(request);
                }
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:service> calling perform service.");
                this.tasklet.performService(request, response);
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] returns from service call.");
                response.setTaskletId(this.tasklet.getTaskletId());
                if (response.getResponseData() == null) {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Protocol: service() method exits with response not set!");
                    throw new IllegalStateException("Protocol: service() method exits with response not set!.");
                }
                if (!(response.getResponseData() instanceof RedirectResponseData)) break block11;
                RedirectResponseData rrdResponse = (RedirectResponseData)response.getResponseData();
                Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Redirect detected.");
                rrdResponse.setNewTaskletId(registry.getNextTaskletId());
                TaskletRegistryEntry childRegistryEntry = new TaskletRegistryEntry();
                childRegistryEntry.redirectResponseData = rrdResponse;
                registry.put(rrdResponse.getNewTaskletId(), childRegistryEntry);
                TaskletRegistryEntry parentRegistryEntry = registry.get(this.tasklet.getTaskletId());
                this.tasklet.setTerminating(true);
                childRegistryEntry.setLastReference(parentRegistryEntry);
                if (rrdResponse.getDelayInitiatorDestroy()) {
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] Delayed death of redirecting tasklet, delaying death.");
                } else {
                    try {
                        this.tasklet.destroy();
                    }
                    catch (RuntimeException e) {
                        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] RuntimeException (" + e + ") caught and ignored when calling tasklet destroy()");
                    }
                    parentRegistryEntry.tasklet = null;
                    Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] <xtsk:death> " + this.tasklet);
                }
                registry.remove(this.tasklet.getTaskletId());
                this.tasklet = null;
            }
            catch (Throwable throwable) {
                response = this.processThrowable(throwable);
            }
            finally {
                this.tooBusyToTerminate(false);
            }
        }
        return response;
    }

    public Object invokeExitOnClient(TaskletClientExitInterface exitObject) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[TaskletManager:" + this.traceId + "] invokeExitOnClient(" + exitObject + ")");
        ExitControlRequest controlRequest = new ExitControlRequest(exitObject);
        this.postControlRequest(controlRequest);
        ExitControlResponse answer = (ExitControlResponse)controlRequest.waitForResponse();
        return answer != null ? answer.getAnswer() : null;
    }
}

